//   2 Aug 2002: Modified path in DeleteCookie().
//  Cookie Functions
//	 Note: If GetCookie(name, key) is called fn_support.js must be loaded.
//			 Not needed for GetCookie(name).
//******************************************************************
//

// "Internal" function to substitute existing cookie value if it contains keys
function SubstCookieValue(name, value) {
	var sValue;
	if(value.indexOf("=") >= 0) // Has keys
		{
		var sKey = StrTokIdx(value,"=",0);
		var sVal = StrTokIdx(value,"=",1);
		sValue = SetCookieKeyVal(GetCookie(name), sKey, sVal); // escapes value
		}
	else
		sValue = escape(value.toString());
	return sValue;
}

// "Internal" function to set cookie value with key=value. Adds or replaces.
function SetCookieKeyVal(sCookieValue, sKey, sVal) {
	var sValue = "";
	var sNewVal = sKey + "=" + escape(sVal);
	if(sCookieValue && sCookieValue.indexOf("=") >= 0) // Has keys
		{
		var sKeyLc = sKey.toLowerCase();
		var sCurVal;
		var bRepl = false;
		for(var i = 0; (sCurVal = StrTokIdx(sCookieValue,"&",i)) && i < 100; ++i)
			{
			if(sValue.length > 0)
				sValue += "&";
			var s0 = StrTokIdx(sCurVal,"=",0);
			var s1 = StrTokIdx(sCurVal,"=",1);
			if(s0 && s0.toLowerCase() == sKeyLc)
				{
				if(! bRepl)
					sValue += sNewVal;
				bRepl = true;
				}
			else
				{
				sCurVal = s0 + "=" + escape(s1);
				sValue += sCurVal;
				}
			}
		if(! bRepl)
			sValue = sNewVal + "&" + sValue;
		}
	else
		sValue = sNewVal;
		
	return sValue;
}
//
// "Internal" function to return the decoded value of a cookie
//
function getCookieVal (offset) {
  var endstr = document.cookie.indexOf (";", offset);
  if (endstr == -1)
    endstr = document.cookie.length;
  return unescape(document.cookie.substring(offset, endstr));
}
//
function GetCookieKeyVal (str, key) {
	var s,s1,i;
	var i = parseInt(key);
	if(isNaN(i))
		{
		key = key.toString();
		key = key.toLowerCase();
		for(i = 0; (s = StrTokIdx(str,"&",i)) && i < 100; ++i)
			{
			s1 = StrTokIdx(s,"=",0);
			if(s1 && s1.toLowerCase() == key)
				return StrTokIdx(s,"=",1);
			}
		return null;
		}
	else
		return StrTokIdx(str,"&",i);
}
//
//  Function to correct for 2.x Mac date bug.  Call this function to
//  fix a date object prior to passing it to SetCookie.
//  IMPORTANT:  This function should only be called *once* for
//  any given date object!  See example at the end of this document.
//
function FixCookieDate (date) {
  var base = new Date(0);
  var skew = base.getTime(); // dawn of (Unix) time - should be 0
  if (skew > 0)  // Except on the Mac - ahead of its time
    date.setTime (date.getTime() - skew);
}
//
//  Function to return the value of the cookie specified by "name" and optional "key".
//    name - String object containing the cookie name. (if null all cookies returned)
//    key  - (Optional) String object containing the cookie key.
//    returns - String object containing the cookie value, or null if
//      the cookie does not exist.
//
function GetCookie (name, key) {
	if(name)
		{
		var arg = name + "=";
		var alen = arg.length;
		var clen = document.cookie.length;
		var i = 0;
		while (i < clen)
			{
			var j = i + alen;
			if (document.cookie.substring(i, j) == arg)
				{
				var sVal = getCookieVal (j);
				if(key && sVal.indexOf("=") >= 0) // Has keys
					sVal = GetCookieKeyVal(sVal,key);
				return sVal;
				}
			i = document.cookie.indexOf(" ", i) + 1;
			if (i == 0) break; 
			}
		return null;
		}
	else
		return document.cookie;
}
//
//  Function to create or update a cookie.
//    name - String object containing the cookie name.
//    value - String object containing the cookie value.  May contain
//      any valid string characters. May also be key=value format.
//    [expires] - Date object containing the expiration data of the cookie.  If
//      omitted or null, expires the cookie at the end of the current session.
//    [path] - String object indicating the path for which the cookie is valid.
//      If omitted or null, uses the path of the calling document.
//    [domain] - String object indicating the domain for which the cookie is
//      valid. If omitted or null, uses the domain of the calling document.
//    [secure] - Boolean (true/false) value indicating whether cookie transmission
//      requires a secure channel (HTTPS).  
//
//  The first two parameters are required.  The others, if supplied, must
//  be passed in the order listed above.  To omit an unused optional field,
//  use null as a place holder.  For example, to call SetCookie using name,
//  value and path, you would code:
//
//      SetCookie ("myCookieName", "myCookieValue", null, "/");
//
//  Note that trailing omitted parameters do not require a placeholder.
//
//  To set a secure cookie for path "/myPath", that expires after the
//  current session, you might code:
//
//      SetCookie (myCookieVar, cookieValueVar, null, "/myPath", null, true);
//
function SetCookie (name,value,expires,path,domain,secure) {

	var n = parseInt(expires);
	if(! isNaN(n))
		{
		expires = new Date ();
		FixCookieDate(expires); // Correct for Mac date bug - call only once for given Date object!
		expires.setTime(expires.getTime() + (n * 3600 * 1000)); // n hrs from now 
		}

	if(! (path))
		path = "/";	// Needed for online
	else if(path == "")
		path = null;

	value = SubstCookieValue(name, value); // Substitutes if value has keys
		
	//document.cookie = name + "=" + escape (value.toString()) +
	document.cookie = name + "=" + value.toString() +
		((expires) ? "; expires=" + expires.toGMTString() : "") +
		((path) ? "; path=" + path : "") +
		((domain) ? "; domain=" + domain : "") +
		((secure) ? "; secure" : "");
}

//  Function to delete a cookie. (Sets expiration date to start of epoch)
//    name -   String object containing the cookie name
//    path -   String object containing the path of the cookie to delete.  This MUST
//             be the same as the path used to create the cookie, or null/omitted if
//             no path was specified when creating the cookie.
//    domain - String object containing the domain of the cookie to delete.  This MUST
//             be the same as the domain used to create the cookie, or null/omitted if
//             no domain was specified when creating the cookie.
//
function DeleteCookie (name,path,domain) {
	if (GetCookie(name))
		{
		if(! (path))
			path = "/";	// Needed for online
		else if(path == "")
			path = null;
		document.cookie = name + "=" +
			((path) ? "; path=" + path : "") +
			((domain) ? "; domain=" + domain : "") +
			"; expires=Thu, 01-Jan-70 00:00:01 GMT";
		}
}

